unit rmmain;

interface

uses
  WinProcs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, msmsg, msmb, mspop3, Buttons,
  IniFiles, Menus, msAbout, msUtils, agTypes, agsocket, Grids;

type
  TmsRemoteMailForm = class(TForm)
    Panel1: TPanel;
    UpdateButton: TSpeedButton;
    RetrieveButton: TSpeedButton;
    RetrCopyButton: TSpeedButton;
    DeleteButton: TSpeedButton;
    ResetButton: TSpeedButton;
    TransferButton: TSpeedButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Updateheaders1: TMenuItem;
    Marktoretrieve1: TMenuItem;
    MarktoDelete1: TMenuItem;
    MarktoRetrieveCopy1: TMenuItem;
    ResetAll1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    TransferData1: TMenuItem;
    Setup1: TMenuItem;
    Help1: TMenuItem;
    msRemotePOP1: TmsRemotePOP;
    About1: TMenuItem;
    ExitButton: TSpeedButton;
    SetupButton: TSpeedButton;
    CancelButton: TSpeedButton;
    Cancel1: TMenuItem;
    Bevel1: TBevel;
    StatusBar1: TPanel;
    StringGrid1: TStringGrid;
    procedure UpdateButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure RetrieveButtonClick(Sender: TObject);
    procedure TransferButtonClick(Sender: TObject);
    procedure RetrCopyButtonClick(Sender: TObject);
    procedure ResetButtonClick(Sender: TObject);
    procedure Setup1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure msRemotePOP1Cancel(Sender: TObject);
    procedure msRemotePOP1Open(Sender: TObject);
    procedure msRemotePOP1UpdatingInfo(Sender: TObject);
    procedure msRemotePOP1InfoUpdated(Sender: TObject);
    procedure msRemotePOP1DataTransfered(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure msRemotePOP1NextInfoUpdated(Sender: TObject;
      Current: Integer);
    procedure msRemotePOP1Closed(Sender: TObject);
    procedure msRemotePOP1Closing(Sender: TObject);
    procedure msRemotePOP1TransferringData(Sender: TObject);
    procedure msRemotePOP1Error(Sender: TObject; var Msg: string);
    procedure CancelButtonClick(Sender: TObject);
    procedure msRemotePOP1UserMessageSave(Sender: TObject; Num: Integer;
      Contents: TMemoryStream);
    procedure StringGrid1Click(Sender: TObject);
  private
    { Private declarations }
    IniName : string;
    procedure ClearStringGrid;
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  msRemoteMailForm: TmsRemoteMailForm;

implementation

uses rmdemosu;

{$R *.DFM}

procedure TmsRemoteMailForm.msRemotePOP1NextInfoUpdated(Sender: TObject;
  Current: Integer);
var
  s,TZ : string;
  Addr,AName : string;
  DT : TDateTime;
begin
  with msRemotePOP1 do
  begin
    with StringGrid1 do
    begin
      RowCount:=Current+2;
      s:='';
      if RemoteInfo[Current].MarkedToRetrieve then
        s:='R';
      if RemoteInfo[Current].MarkedToDelete then
        s:=Concat(s,'D');
      Cells[0,Current+1]:=s;
      Cells[1,Current+1]:=RemoteInfo[Current].Headers.GetFieldBody('Subject');
      s:=RemoteInfo[Current].Headers.GetFieldBody('From');
      SplitAddress(s,Addr,AName);
      if AName='' then s:=Addr
        else s:=AName;
      Cells[2,Current+1]:=s;
      Cells[3,Current+1]:=IntToStr(RemoteInfo[Current].Size);
      s:=RemoteInfo[Current].Headers.GetFieldBody('Date');
      MailDateToDateTime(s,DT,TZ);
      if DT<>0 then
        s:=DateTimeToStr(DT);
      Cells[4,Current+1]:=s;
    end;
  end;
end;

procedure TmsRemoteMailForm.ClearStringGrid;
var
  i : Integer;
begin
  if StringGrid1.RowCount>1 then
  begin
    for i:=1 to StringGrid1.RowCount-1 do
      StringGrid1.Rows[i].Clear;
  end;
end;

procedure TmsRemoteMailForm.UpdateButtonClick(Sender: TObject);
begin
  ClearStringGrid;
  CancelButton.Enabled:=true;
  Cancel1.Enabled:=true;
  msRemotePOP1.UpdateRemoteInfo;
  CancelButton.Enabled:=false;
  Cancel1.Enabled:=false;
end;

procedure TmsRemoteMailForm.DeleteButtonClick(Sender: TObject);
var
  s : string;
  Index : Integer;
begin
  Index:=StringGrid1.Row-1;
  msRemotePOP1.MarkToDelete(Index);
  s:=StringGrid1.Cells[0,Index+1];
  if Length(s)>0 then
    s[1]:='D' else s:='D';
  StringGrid1.Cells[0,Index+1]:=s;
end;

procedure TmsRemoteMailForm.RetrieveButtonClick(Sender: TObject);
var
  Index : Integer;
begin
  Index:=StringGrid1.Row-1;
  msRemotePOP1.MarkToRetrieve(Index);
  msRemotePOP1.MarkToDelete(Index);
  StringGrid1.Cells[0,Index+1]:='DR';
end;

procedure TmsRemoteMailForm.TransferButtonClick(Sender: TObject);
begin
  ClearStringGrid;
  CancelButton.Enabled:=true;
  Cancel1.Enabled:=true;
  msRemotePOP1.Transfer;
  msRemotePOP1.UpdateRemoteInfo;
  CancelButton.Enabled:=false;
  Cancel1.Enabled:=false;
end;

procedure TmsRemoteMailForm.RetrCopyButtonClick(Sender: TObject);
var
  Index : Integer;
  s : string;
begin
  Index:=StringGrid1.Row-1;
  msRemotePOP1.MarkToRetrieve(Index);
  s:=StringGrid1.Cells[0,Index+1];
  if Length(s)=1 then
    s:=s+'R'
  else
    s:=' R';
  StringGrid1.Cells[0,Index+1]:=s;
end;

procedure TmsRemoteMailForm.ResetButtonClick(Sender: TObject);
var
  i : Integer;
begin
  for i:=0 to msRemotePOP1.RemoteInfo.Count-1 do
  begin
    msRemotePOP1.Reset(i);
    StringGrid1.Cells[0,i+1]:='';
  end;
end;

procedure TmsRemoteMailForm.Setup1Click(Sender: TObject);
begin
  with TSetupDlg.Create(Self) do
  try
    ServerEdit.Text:=msRemotePOP1.Server;
    UserNameEdit.Text:=msRemotePOP1.UserName;
    PasswordEdit.Text:=msRemotePOP1.Password;
    LogFileNameEdit.Text:=msRemotePOP1.LogFileName;
    AttDirEdit.Text:=msRemotePOP1.MessageDirectory;
    if ShowModal=mrOk then
    begin
      msRemotePOP1.Server:=ServerEdit.Text;
      msRemotePOP1.UserName:=UserNameEdit.Text;
      msRemotePOP1.Password:=PasswordEdit.Text;
      msRemotePOP1.LogFileName:=LogFileNameEdit.Text;
      msRemotePOP1.MessageDirectory:=AttDirEdit.Text;
    end;
  finally
    free;
  end;
end;

procedure TmsRemoteMailForm.FormCreate(Sender: TObject);
begin
  IniName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    msRemotePOP1.Server:=ReadString('Setup','Server','');
    msRemotePOP1.UserName:=ReadString('Setup','User Name','');
    msRemotePOP1.Password:=ReadString('Setup','Password','');
    msRemotePOP1.LogFileName:=ReadString('Setup','Log File','');
    msRemotePOP1.MessageDirectory:=ReadString('Setup','Messages','');
  finally
    free;
  end;
  with StringGrid1 do
  begin
    Cells[0,0]:='Status';
    Cells[1,0]:='Subject';
    Cells[2,0]:='From';
    Cells[3,0]:='Size';
    Cells[4,0]:='Date';
  end;
  DisableControls;
end;

procedure TmsRemoteMailForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  with TIniFile.Create(IniName) do
  try
    WriteString('Setup','Server',msRemotePOP1.Server);
    WriteString('Setup','User Name',msRemotePOP1.UserName);
    WriteString('Setup','Password',msRemotePOP1.Password);
    WriteString('Setup','Log File',msRemotePOP1.LogFileName);
    WriteString('Setup','Messages',msRemotePOP1.MessageDirectory);
  finally
    free;
  end;
end;

procedure TmsRemoteMailForm.msRemotePOP1Cancel(Sender: TObject);
begin
  StatusBar1.Caption:='Operation has been canceled';
end;

procedure TmsRemoteMailForm.msRemotePOP1Open(Sender: TObject);
begin
  StatusBar1.Caption:='Opening connection';
end;

procedure TmsRemoteMailForm.msRemotePOP1UpdatingInfo(Sender: TObject);
begin
  StatusBar1.Caption:='Updating headers';
end;

procedure TmsRemoteMailForm.msRemotePOP1InfoUpdated(Sender: TObject);
begin
  StatusBar1.Caption:=IntToStr(msRemotePOP1.RemoteInfo.Count)+' message(s)';
end;

procedure TmsRemoteMailForm.msRemotePOP1DataTransfered(Sender: TObject);
begin
  StatusBar1.Caption:='Data has been transfered';
end;

procedure TmsRemoteMailForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if msRemotePOP1.OnLine then
    msRemotePOP1.CloseConnection;
end;

procedure TmsRemoteMailForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TmsRemoteMailForm.About1Click(Sender: TObject);
begin
  with TAboutDlg.Create(Self) do
  try
    ProgramName.Caption:='Remote Mail Demo';
    ProductVersion.Caption:=msVersion;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TmsRemoteMailForm.EnableControls;
var
  i : Integer;
begin
  for i:=0 to ComponentCount-1 do
  begin
    if (Components[i] is TSpeedButton) and ((Components[i] as TSpeedButton).Tag=1)
      then (Components[i] as TSpeedButton).Enabled:=true;
    if (Components[i] is TMenuItem) and ((Components[i] as TMenuItem).Tag=1)
      then (Components[i] as TMenuItem).Enabled:=true;
  end;
end;

procedure TmsRemoteMailForm.DisableControls;
var
  i: Integer;
begin
  for i:=0 to ComponentCount-1 do
  begin
    if (Components[i] is TSpeedButton) and ((Components[i] as TSpeedButton).Tag=1)
      then (Components[i] as TSpeedButton).Enabled:=false;
    if (Components[i] is TMenuItem) and ((Components[i] as TMenuItem).Tag=1)
      then (Components[i] as TMenuItem).Enabled:=false;
  end;
end;

procedure TmsRemoteMailForm.msRemotePOP1Closed(Sender: TObject);
begin
  StatusBar1.Caption:='Connection closed';
end;

procedure TmsRemoteMailForm.msRemotePOP1Closing(Sender: TObject);
begin
  StatusBar1.Caption:='Closing connection';
end;

procedure TmsRemoteMailForm.msRemotePOP1TransferringData(Sender: TObject);
begin
  StatusBar1.Caption:='Transferring data';
end;

procedure TmsRemoteMailForm.msRemotePOP1Error(Sender: TObject;
  var Msg: string);
begin
  StatusBar1.Caption:=Msg;
end;

procedure TmsRemoteMailForm.CancelButtonClick(Sender: TObject);
begin
  msRemotePOP1.Cancel;
  ClearStringGrid;
end;

procedure TmsRemoteMailForm.msRemotePOP1UserMessageSave(Sender: TObject;
  Num: Integer; Contents: TMemoryStream);
{ Duplicates default behavior - the same will happen if this event
  is not attached.  But you can handle the incoming messages your way.}
var
  FileName : string;
begin
  FileName:=Concat(msRemotePOP1.MessageDirectory,'msg_',IntToStr(Num),'.eml');
  Contents.SaveToFile(FileName);
end;

procedure TmsRemoteMailForm.StringGrid1Click(Sender: TObject);
begin
  if StringGrid1.RowCount>1 then EnableControls
    else DisableControls;
end;

end.
